unit WinForm;

interface

uses
  System.Drawing, System.Collections,
  System.ComponentModel,
  System.Windows.Forms,
  System.Data,
  Borland.Eco.Windows.Forms,
  Borland.Eco.WinForm,
  Borland.Eco.Handles,
  CodeDerivedColumnEcoSpace,
  CoreClassesUnit, 
  System.Resources;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    EcoGlobalActions: Borland.Eco.WinForm.EcoActionExtender;
    EcoAutoForms: Borland.Eco.WinForm.EcoAutoFormExtender;
    EcoListActions: Borland.Eco.WinForm.EcoListActionExtender;
    EcoDragDrop: Borland.Eco.WinForm.EcoDragDropExtender;
    btnTestData: System.Windows.Forms.Button;
    grdProducts: System.Windows.Forms.DataGrid;
    ehAllProducts: Borland.Eco.Handles.ExpressionHandle;
    DataGridTableStyle1: System.Windows.Forms.DataGridTableStyle;
    DataGridTextBoxColumn1: System.Windows.Forms.DataGridTextBoxColumn;
    DataGridTextBoxColumn2: System.Windows.Forms.DataGridTextBoxColumn;
    DataGridTextBoxColumn3: System.Windows.Forms.DataGridTextBoxColumn;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure ExpressionHandle1_DeriveValue(sender: System.Object; e: Borland.Eco.Handles.DeriveEventArgs);
    procedure ExpressionHandle1_ReverseDeriveValue(sender: System.Object; e: Borland.Eco.Handles.ReverseDeriveEventArgs);
    procedure btnTestData_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    FEcoSpace: TCodeDerivedColumnEcoSpace;
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
    property EcoSpace: TCodeDerivedColumnEcoSpace read FEcoSpace;
  end;

implementation

uses
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.Services,
  System.Text;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
type
  TArrayOfSystem_Windows_Forms_DataGridTableStyle = array of System.Windows.Forms.DataGridTableStyle;
  TArrayOfBorland_Eco_Handles_AbstractColumn = array of Borland.Eco.Handles.AbstractColumn;
  TArrayOfBorland_Eco_Handles_Nesting = array of Borland.Eco.Handles.Nesting;
  TArrayOfSystem_Windows_Forms_DataGridColumnStyle = array of System.Windows.Forms.DataGridColumnStyle;
var
  resources: System.Resources.ResourceManager;
  Nesting11: Borland.Eco.Handles.Nesting;
  EventDerivedColumn12: Borland.Eco.Handles.EventDerivedColumn;
  EventDerivedColumn11: Borland.Eco.Handles.EventDerivedColumn;
  OclColumn11: Borland.Eco.Handles.OclColumn;
begin
  OclColumn11 := Borland.Eco.Handles.OclColumn.Create;
  EventDerivedColumn11 := Borland.Eco.Handles.EventDerivedColumn.Create;
  EventDerivedColumn12 := Borland.Eco.Handles.EventDerivedColumn.Create;
  Nesting11 := Borland.Eco.Handles.Nesting.Create;
  resources := System.Resources.ResourceManager.Create(TypeOf(TWinForm));
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  Self.EcoGlobalActions := Borland.Eco.WinForm.EcoActionExtender.Create;
  Self.EcoAutoForms := Borland.Eco.WinForm.EcoAutoFormExtender.Create;
  Self.grdProducts := System.Windows.Forms.DataGrid.Create;
  Self.ehAllProducts := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.DataGridTableStyle1 := System.Windows.Forms.DataGridTableStyle.Create;
  Self.DataGridTextBoxColumn1 := System.Windows.Forms.DataGridTextBoxColumn.Create;
  Self.EcoListActions := Borland.Eco.WinForm.EcoListActionExtender.Create;
  Self.EcoDragDrop := Borland.Eco.WinForm.EcoDragDropExtender.Create;
  Self.btnTestData := System.Windows.Forms.Button.Create;
  Self.DataGridTextBoxColumn2 := System.Windows.Forms.DataGridTextBoxColumn.Create;
  Self.DataGridTextBoxColumn3 := System.Windows.Forms.DataGridTextBoxColumn.Create;
  (System.ComponentModel.ISupportInitialize(Self.grdProducts)).BeginInit;
  Self.SuspendLayout;
  // 
  // rhRoot
  // 
  Self.rhRoot.EcoSpaceType := TypeOf(CodeDerivedColumnEcoSpace.TCodeDerivedColumnEcoSpace);
  // 
  // EcoGlobalActions
  // 
  Self.EcoGlobalActions.RootHandle := Self.rhRoot;
  // 
  // grdProducts
  // 
  Self.grdProducts.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.grdProducts.CaptionText := 'List of all products';
  Self.grdProducts.DataMember := '';
  Self.grdProducts.DataSource := Self.ehAllProducts;
  Self.EcoAutoForms.SetEcoAutoForm(Self.grdProducts, True);
  Self.grdProducts.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.grdProducts.Location := System.Drawing.Point.Create(8, 8);
  Self.grdProducts.Name := 'grdProducts';
  Self.grdProducts.Size := System.Drawing.Size.Create(368, 280);
  Self.grdProducts.TabIndex := 1;
  Self.grdProducts.TableStyles.AddRange(TArrayOfSystem_Windows_Forms_DataGridTableStyle.Create(Self.DataGridTableStyle1));
  // 
  // ehAllProducts
  // 
  Self.ehAllProducts.AddDefaultProperties := False;
  OclColumn11.Expression := 'Name';
  OclColumn11.Name := 'Name';
  EventDerivedColumn11.Name := 'Reversed';
  EventDerivedColumn11.TypeName := 'System.String';
  EventDerivedColumn12.IsReadOnly := True;
  EventDerivedColumn12.Name := 'IsPalindrome';
  EventDerivedColumn12.TypeName := 'System.Boolean';
  Self.ehAllProducts.Columns.AddRange(TArrayOfBorland_Eco_Handles_AbstractColumn.Create(OclColumn11, 
          EventDerivedColumn11, EventDerivedColumn12));
  Self.ehAllProducts.Expression := 'Product.allInstances';
  Nesting11.Name := 'New1';
  Nesting11.TypeName := 'Product';
  Self.ehAllProducts.Nestings.AddRange(TArrayOfBorland_Eco_Handles_Nesting.Create(Nesting11));
  Self.ehAllProducts.RootHandle := Self.rhRoot;
  Include(Self.ehAllProducts.DeriveValue, Self.ExpressionHandle1_DeriveValue);
  Include(Self.ehAllProducts.ReverseDeriveValue, Self.ExpressionHandle1_ReverseDeriveValue);
  // 
  // DataGridTableStyle1
  // 
  Self.DataGridTableStyle1.DataGrid := Self.grdProducts;
  Self.DataGridTableStyle1.GridColumnStyles.AddRange(TArrayOfSystem_Windows_Forms_DataGridColumnStyle.Create(Self.DataGridTextBoxColumn1, 
          Self.DataGridTextBoxColumn2, Self.DataGridTextBoxColumn3));
  Self.DataGridTableStyle1.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.DataGridTableStyle1.MappingName := '';
  // 
  // DataGridTextBoxColumn1
  // 
  Self.DataGridTextBoxColumn1.Format := '';
  Self.DataGridTextBoxColumn1.FormatInfo := nil;
  Self.DataGridTextBoxColumn1.HeaderText := 'Name';
  Self.DataGridTextBoxColumn1.MappingName := 'Name';
  Self.DataGridTextBoxColumn1.Width := 75;
  // 
  // btnTestData
  // 
  Self.btnTestData.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.btnTestData.Location := System.Drawing.Point.Create(264, 296);
  Self.btnTestData.Name := 'btnTestData';
  Self.btnTestData.Size := System.Drawing.Size.Create(112, 23);
  Self.btnTestData.TabIndex := 0;
  Self.btnTestData.Text := 'Create test data';
  Include(Self.btnTestData.Click, Self.btnTestData_Click);
  // 
  // DataGridTextBoxColumn2
  // 
  Self.DataGridTextBoxColumn2.Format := '';
  Self.DataGridTextBoxColumn2.FormatInfo := nil;
  Self.DataGridTextBoxColumn2.HeaderText := 'Reversed';
  Self.DataGridTextBoxColumn2.MappingName := 'Reversed';
  Self.DataGridTextBoxColumn2.Width := 75;
  // 
  // DataGridTextBoxColumn3
  // 
  Self.DataGridTextBoxColumn3.Format := '';
  Self.DataGridTextBoxColumn3.FormatInfo := nil;
  Self.DataGridTextBoxColumn3.HeaderText := 'IsPalindrome';
  Self.DataGridTextBoxColumn3.MappingName := 'IsPalindrome';
  Self.DataGridTextBoxColumn3.Width := 75;
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(384, 325);
  Self.Controls.Add(Self.grdProducts);
  Self.Controls.Add(Self.btnTestData);
//  Self.Icon := (System.Drawing.Icon(resources.GetObject('$this.Icon')));
  Self.Name := 'TWinForm';
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'Code Derived Column';
  (System.ComponentModel.ISupportInitialize(Self.grdProducts)).EndInit;
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  FEcoSpace := TCodeDerivedColumnEcoSpace.Create;
  rhRoot.EcoSpace := FEcoSpace;
  // The line below will automatically activate the ECO Space on form create.
  // Remove the line if you wish to activate it manually

  FEcoSpace.Active := True;
end;

procedure TWinForm.btnTestData_Click(sender: System.Object; e: System.EventArgs);
begin
  Product.Create(EcoSpace).Name := 'rotor';
  Product.Create(EcoSpace).Name := 'book';
  Product.Create(EcoSpace).Name := 'civic';
  Product.Create(EcoSpace).Name := 'airplane';
  Product.Create(EcoSpace).Name := 'radar';
  Product.Create(EcoSpace).Name := 'ABBA';
end;

function Reverse(Value :String): string;
var
  Len, i: integer;
  sb: StringBuilder;
begin
  sb := StringBuilder.Create(Length(Value));
  Len := Length(Value);
  for i := len downto 1 do
    sb.Append(value[i]);
  result := sb.ToString;
end;

procedure TWinForm.ExpressionHandle1_ReverseDeriveValue(sender: System.Object;
  e: Borland.Eco.Handles.ReverseDeriveEventArgs);
begin
  if e.Name = 'Reversed' then
    (e.RootElement.AsObject as Product).Name := Reverse(string(e.Value));
end;

function IsPalindrom(Value :String): Boolean;
var
  Len, i: integer;
begin
  Result := true;
  Len := Length(Value);
  for i := 1 to len do
    if value[i] <> value[Len + 1 - i] then
      Result := False;
end;


procedure TWinForm.ExpressionHandle1_DeriveValue(sender: System.Object; e: Borland.Eco.Handles.DeriveEventArgs);
var
  Name: string;
begin
  if e.Name = 'IsPalindrome' then
  begin
    // Easiest way to get subscription right is to use OCL avaluator
    Name := e.OclService.EvaluateAndSubscribe(e.RootElement,'self.Name', e.ValueChangeSubscriber, e.ResubscribeSubscriber).AsObject as string;;
    e.ResultElement := EcoSpace.VariableFactoryService.CreateConstant(IsPalindrom(Name));
  end
  else if e.Name = 'Reversed' then
  begin
    Name := e.OclService.EvaluateAndSubscribe(e.RootElement,'self.Name', e.ValueChangeSubscriber, e.ResubscribeSubscriber).AsObject as string;;
    e.ResultElement := EcoSpace.VariableFactoryService.CreateConstant(Reverse(Name));
  end
  else
    raise ArgumentException.Create('Unknown column');
end;


end.
